//webpack.config.js
const path = require('path');
const webpack = require('webpack');
const ExtractTextPlugin = require('extract-text-webpack-plugin');
const BrowserSyncPlugin = require('browser-sync-webpack-plugin');

const bundleJquery = new webpack.ProvidePlugin({
    jQuery: "jquery"
});
const bundleExtractPlugin = new ExtractTextPlugin({
    filename: 'style.min.css'
});
const moduleBrowerSyncPlugin = new BrowserSyncPlugin({
    host: 'agence.jlcw',
    port: 3000,
    proxy: 'agence.jlcw',
    urlOverride: '',
    open: false
});

module.exports = (env) => {
    return {
        name: 'client',
        target: 'web',
        entry: {
            main: ['babel-polyfill', './src/js/app.js', './src/scss/main.scss'],
        },
        output: {
            path: path.resolve(__dirname, 'dist'),
            filename: "bundle.js",
            publicPath: 'dist'
        },
        externals: {
            jQuery: 'jQuery',
        },
        devtool:  env === 'dev' ? 'eval-cheap-modules-source-map' : false,
        module: {
            rules: [
                {
                    test: /\.js$/,
                    exclude: /node_modules/,
                    loader: "babel-loader",
                    options: {plugins: ['transform-runtime'], presets: ['es2015']}
                },
                {
                    test: /\.(css|scss)/,
                    exclude: /node_modules/,
                    use: ExtractTextPlugin.extract(['css-loader', 'sass-loader'])
                },
                {
                    test: /\.html$/,
                    exclude: /node_modules/,
                    loader: 'raw-loader'
                },
                {
                    test: /\.(png|jpg|jpeg|svg|gif)$/,
                    exclude: /node_modules/,
                    use: [
                        {
                            loader: 'url-loader',
                            options: {
                                limit: 8192
                            }
                        },
                    ]
                },
                {
                    test: /\.woff($|\?)|\.woff2($|\?)|\.ttf($|\?)|\.otf($|\?)|\.eot($|\?)/,
                    exclude: /node_modules/,
                    use: [{
                        loader: 'file-loader',
                        options: {
                            name: '[name].[ext]',
                            outputPath: '/fonts/',
                            publicPath: './fonts/',
                        }
                    }]
                },
            ]
        },
        resolve: {
            alias: {
            }
        },

        plugins: [
            bundleExtractPlugin,
            bundleJquery,
            moduleBrowerSyncPlugin
        ]
    }
}